# 第八章 中国开源发展的机遇和挑战

## 8.1 中国开源发展的机遇
### 8.1.1 中国正成为全球开源市场的增长点

移动互联网与云计算在中国的快速发展，吸引了全球范围内的开源项目进入中国市场，极大的市场容量促使以云原生为代表的新型订阅收费模式快速变现。而吸引众多全球开发者的另一个因素，是国内大型企业将其产品陆续开源以及大量以开源为基础的初创公司开始涌现。

中国具备全球最完善的电子工业产业链，许多开源技术在中国市场找到载体最终销往全球。开源技术本地化，并在本地提供服务和二次开发的过程，是一个明显的趋势，并且该过程会降低开源在中国产业生态内的应用和产业化门槛，RISC-V、TWS等技术在中国的快速产业化就是最佳案例。特别是软件、硬件结合的产品及软硬一体化的应用解决方案，依托中国完备、高效的产业生态，有利于在全球市场占据领先地位。尤其在IoT和AIoT领域，中国的产业链优势显而易见，这也是中国开源发展的一个历史机遇。

而随着IoT和AIoT的发展，数据将从万物互联中产生。中国制造业的市场规模与快速迭代的优势，将带来更多的技术创新。加快中国开源市场增长的步伐，TDengine、Apache IoTDB等中国开源力量的崛起，就是因为中国IoT和AIoT快速发展的核心动力作为支撑。

此外，开源订阅服务费的商业模式，和可定制化的开放技术架构为中国企业降低了市场门槛与学习成本，提升了性价比。高价值的商业需求反馈到开源社区，引领技术向服务商业、服务客户的方向发展，可以形成收益闭环，进而反哺开源项目和开发者。这是开源项目发展壮大的必要过程，要接地气，要服务用户，要形成产业，要变现，最终实现开源商业共赢的可持续发展模式，中国在其中最大的作用是产业的快速发展帮助开源项目快速迭代，引领企业走上商业友好的可持续发展路线，也就是帮助开源项目升级迭代，有效集成开源技术并售卖到全球，实现盈利分成。
 
### 8.1.2 开源逐步渗透传统行业 

据新思科技调研，截至2021年，在其调研的1546个商业代码库中，有98-99%包含开源代码。新思科技调研的企业代码库涵盖了17个不同的行业，其中包括电信、物联网、金融科技和航空航天，代码库中开源代码占比排名前三的行业为物联网（89%）；网络安全与制造业（84%）；教育、互联网、市场技术、医疗与生命科学（82%）。与2019年相比，制造业开源代码占比增长30%，医疗与生命科学开源代码占比增长17%，物联网、市场技术、教育行业均有50%以上的增长。可见，开源代码向传统行业渗透已成趋势。

在国内传统行业中，金融、电信、医疗是开源渗透率较高的三个行业。根据主要开源供应商向CSDN提供的来自19个不同行业的156个企业案例中，金融业、运营商以及政务、医疗行业的案例占比最高。其中，金融行业案例占比17.3%，电信行业运营商占比10.9%，医疗行业案例占比为9.6%。同时，这金融和电信行业中近年来涌现了许多优秀的开源项目。金融行业以微众银行为代表，已发起20余个开源项目，其中两个已于2021年进入Apache孵化器。电信行业中，以中国移动为代表的中国运营商与海外企业合作，参与推动了包括ONAP，Edge，G-SRv6等基于平台、关键部件、系统与集成领域的开源项目。

在开源社区建设方面，金融、电信、制造业等传统行业也已经形成行业特色。行业开源社区主要承担行业内的开源代码服务、供需对接、行业开源治理推动、开源规范制定、企业交流及开原生态建设等角色，极大地推动了各行业开源协作、开源实践。其中，金融行业于2018年10月由浦发银行和华为联合上海银行、上海农商银行、中国人寿、上海清算所等多家金融机构及中国信通院、富麦科技等合作伙伴成立了金融行业开源技术应用社区，其成员包括四十余家金融机构以及8家互联网公司。制造业于2018年成立工业技术软件化开源社区（OSIICN），现入驻工业互联网领域企业超过1000家，汇集合计年产值过万亿元的企业集群，其中包括华为、中信科、航天云网、树根互联等44家工业互联网领军企业，400余家软件企业、43个创新中心和百余名行业专家，以及大量工业软件个人开发者。电信行业于2021年9月由中国信息通信研究院牵头发起的“通信行业开源社区（ICTOSC）”在OSCAR开源产业大会上正式成立，首批15个企业成员加入，包括12家运营商单位。由此可见，传统行业的开源社区建设初见成果，有可供其它行业借鉴的实践经验。

毫无疑问，开源将在传统企业展现更多的力量，而传统行业积极拥抱开源、引入开源软件的背后，是其业务发展导致的企业对持续变化的业务需求响应能力、软件性能及成本与效率方面的考虑。出于传统行业的增长需求、市场环境的变化、客户需求的多样性等原因，传统企业自身的研发能力不足以支撑企业敏捷响应、快速迭代、开发，制约了企业的快速发展，尤其是金融、物联网等行业的应用场景规模大、高并发，对企业应用的软件性能有严苛要求。但企业根据需求自研系统或引入外部商业软件都会带来高昂的采购成本、维护成本和人力投入。

在此背景下，开源由于其开放式协作的特点，使得开发流程更为敏捷，业务需求和变化能快速得到响应，而且开源社区为企业与外部精英提供合作平台，可以解决短期内传统行业研发实力不足的问题。引入开源软件意味着企业可以基于原有开源代码自行开发或只需采购增量服务，节约时间、人力、经济成本。传统行业引入开源软件提升了企业业务竞争力，驱动了企业数字化转型，并且帮助企业系统实现了安全性和可靠性提升。从全局角度而言，传统行业拥抱开源为其带来了新的增长机遇。

### 8.1.3 开源正与各技术领域深度融合
 
开源软件的发展从从操作系统开始，发展到数据库、中间件，并向应用领域逐渐延展，进而在近年来开始主导深度信息技术领域的创新，开源正在与各技术领域深度融合。其中，数据库、云原生与开源项目的结合最为紧密，操作系统领域也出现大量成熟的Linux发行版，很多企业开始自研开源的实时操作系统。在新技术领域，人工智能、物联网、元宇宙等技术也逐渐拥抱开源并落地开源产品。中国高度重视各个技术领域在开源方向的前瞻性布局，无论是项目活跃度，还是项目影响力，都在快速提升。 

在数据库领域，开源展现出两大趋势。一是国产商业数据库逐渐走向开源，其中华为的openGauss、阿里云的PolarDB、奥星贝斯的OceanBase等，开始致力于为国内数据库行业构建基础根技术和根生态；二是中国在分布式、实时数仓等方向的开源产品已经成为了全球范围内的优秀项目，如PingCAP的TiDB、Apache基金会的Doris和HAWQ等。

在人工智能领域，深度学习已经是技术创新与开源落地的主要方向。自2017年发布的《新一代人工智能发展规划》提出开源开放的原则后，共同建设AI技术体系成为了众多人工智能企业的共同目标，自动驾驶、医疗影像、普惠金融、智能供应链等新一代人工智能开放创新平台诞生。人工智能等重大科技项目开源开放，以开源的形式提升创新质量，有力地推动了产业进程。如今人工智能与开源融合已成行业共识：人工智能开源有助于支撑人工智能领域形成高端产业集群优势，逐步引领世界前沿技术的发展；人工智能开源有助于吸引更多人才进入人工智能产业，建设多层次人才培养体系；人工智能开源有助于推动人工智能广泛应用，加快推动人工智能与各行业的融合创新和赋能。

在物联网领域，开源在智能网联汽车中表现出的应用机遇尤为显著。汽车软件会变成一个由开源和专有组件组成的生态系统，共同提供软件组件的可选择性和灵活性，采用敏捷的软件开发、发布、更新模式也是必要的。充分利用已验证过的开源软件构建智能驾驶软件生态已经成为重要趋势，如在IVI应用方面普遍采用Android、Linux等开源操作系统，以及开源通信中间件（DDS）框架、开源机器学习框架等。汽车的安全与实时性至关重要，在使用开源软件的过程中，以安全性和附加服务为核心属性，不断强化产品。对于主流汽车厂商，使用开源软件的前景将具有巨大的吸引力，因为它保留了对全栈软件的控制权，包括他们的数据。

在元宇宙领域，由GitHub社区数据可知，2021 Q3新建的元宇宙开源项目数量为102个，同比增长827%，环比增长252%，元宇宙携手开源可谓来势汹汹。开源世界是建立元宇宙的首选之地，其具备构建元宇宙所需要的所有内容和软件，而且完全免费。对元宇宙这样的新兴技术而言，开源是极其重要的工具与理念，可以吸引全球所有的开发者、厂商、科研机构共同参与技术研发，从而推动行业加速成熟，快速达到商用水平。更重要的是，在各界人士广泛的参与下，才能形成严密完整的技术逻辑，补全伦理、道德等方面的缺陷，使其被主流社会接受。

此外，开源是元宇宙成为公共可信生存空间的必然前提。元宇宙作为与现实社会孪生的公共虚拟空间，其资源禀赋、运行机制必需是可视、可解释的，才能形成共同的信任基础，因此，开源必然是元宇宙的核心特征和要求之一。元宇宙是技术公司、科技人员、普通参与者共同创造的“宇宙”，除了个体掌控的私有数据外，所有一切都是开源的。代码是开源的，在开源社区可以随意查看开源代码；技术是开源的，所有元宇宙的技术底层逻辑都是公开的；公共数据是开源的，所有人皆可查看和使用，以此规避中心化平台的垄断；内容是开源的，任何人都能创造元宇宙的内容；智能合约是开源的，任何人都可以调用智能合约。

如今，开源与各技术领域携手同行的势头有增无已，开源有助于各技术领域扩大人才规模及上下游生态影响力，通过运营开源社区快速获得反馈并加快产品开发、提升产品质量，同时反哺社区开发者及独立软件开发商（ISV）等生态伙伴，能够达到多方共赢目的。

### 8.2.1 开源面临技术安全风险
开源软件漏洞数量保持高位。

根据Synopsys公司《2021开源安全和风险分析报告》，Black Duck审计服务团队在2020年审计的涵盖17个行业的1546个流行代码库中，98%的代码库包含开源代码，75%的代码由开源代码构成，84%的包含至少一个漏洞，每个代码库平均有158个漏洞，65%的代码库存在许可证冲突。

而GitHub官方数据显示，2018年新增开源漏洞数也创下近6年新高，新增 7563 个漏洞， 2019年与 2020 年增长率略有下降，2020年发布的漏洞数较 2019 年发布漏洞数少了1746条。具体数据如图1。

![](https://img-blog.csdnimg.cn/e366d7395bd54c59b2eb300b9e2e2460.png)<br/>*开源漏洞时间分布*

奇安信代码安全实验室《2021中国软件供应链安全分析报告》显示，截至2020年底，CVE/NVD、CNNVD、CNVD等公开漏洞库中共收录开源软件相关漏洞41342个，其中5366个为2020年度新增漏洞。而在奇安信代码安全实验室审计的2557个国内企业软件项目中，存在已知开源软件漏洞的项目有2280个，占比高达89.2%；存在已知高危开源软件漏洞的项目有2062个，占比为80.6%；存在已知超危开源软件漏洞的项目有1802个，占比为70.5%。这些项目中，共检出168604个已知开源软件漏洞（涉及到4166个CVE漏洞编号），平均每个软件项目存在66个已知开源软件漏洞，最多的软件项目存在1200个已知开源软件漏洞。而从漏洞的影响角度来看，最多的Spring Framework安全漏洞CVE-2020-5421影响了44.3%的软件项目，多个漏洞影响了超过30%的项目。输入验证、路径遍历、跨站脚本、注入、NULL引用、资源管理、密码管理、API误用、配置管理、日志伪造等十类安全缺陷是程序员在编写软件代码时经常会出现的典型安全缺陷。在2020年检测的1364个开源软件项目中，十类典型安全缺陷的总体检出率为56.3%，每类典型缺陷的检出率及排名如表1所示。

![](https://img-blog.csdnimg.cn/81f313413e9147aebcbfe7884a79b3a2.png)<br/>*基于Log4j 2漏洞的攻击数量迅速上升*


开源软件漏洞影响范围巨大。

根据Synopsys公司《2021开源安全和风险分析报告》，2020年再次发现了2019年前十大开源漏洞 (包括一个高风险漏洞 )， 其中一些漏洞的百分比显著增加。

以2021年影响最大的Apache Log4j2漏洞事件为例。2021年12月，Apache Log4j2被发现其某些功能存在递归解析功能，存在攻击者可直接构造恶意请求，触发远程代码执行的漏洞。根据工信部发布的《关于阿帕奇Log4j2组件重大安全漏洞的网络安全风险提示》，该漏洞可能导致设备远程受控，进而引发敏感信息窃取、设备服务中断等严重危害，属于高危漏洞。

据Check Point Research统计漏洞爆发4天（自12月10日至12月13日）情况报告，在Apache Log4j 2漏洞发现早期的12月10日，黑客尝试利用该漏洞进行攻击的次数仅有几千次，但这一数据在隔天却增至4万次。而漏洞爆发72小时后，捕捉到利用该漏洞尝试攻击的行为就已超过83万次，如下图所示。


![](https://img-blog.csdnimg.cn/3b5abc2556564468b7fd28308d41e944.png)<br/>*基于Log4j 2漏洞的攻击数量迅速上升*

不仅攻击次数在持续攀升，基于该漏洞的新变种也在短时间内迅速衍生。Log4j 2作为一个基于Java的日志框架影响范围之广远超开发团队的预想，全球近一半企业因为该漏洞受到了黑客的试图攻击。并且由于Apache Log4j 2应用范围大、漏洞修复较为复杂，而利用漏洞却十分简便，因此这Apache Log4j 2漏洞很可能在未来几年内也将一直存在。
	
### 8.2.2 开源面临法律风险
**开源许可证法律效力有待进一步明确。**

根据Synopsys公司《2021开源安全和风险分析报告》，2020年的被审代码库中有65%包含存在许可证冲突的开源代码。纵观存在许可证冲突的代码库，近四分之三与某个版本的“GNU通用公共许可证”存在冲突。26%的被审代码库使用了没有许可证或定制许可证的开源代码。使用定制开源代码许可证的代码库是否存在可能的IP和其他法律问题，需要评估后才能确定。例如，JSON许可证实质上是宽松型MIT许可证，只不过添加了“该款软件严禁用于恶意用途，仅限用于善意用途”的注释。许多热门项目的责任方都因为许可证定义含糊不清而删除了使用JSON许可证的代码，因为“善意用途”与“恶意用途”定义争议性极强，很难界定。

国内司法实践中逐步开始重视开源许可证的法律效应。2021年4月，广东省深圳市中级人民法院审理罗盒公司诉风灵公司案的一审判决，该案明确指出 GPLv3协议是一种民事法律行为，具有合同性质，可以认定为授权人和用户间订立的著作权协议，属于《合同法》调整的范围。此案例是国内首个明确GPLv3 协议法律效力的案例，对开源许可证的法律界定，对开源软件侵权行为的判罚作出了有益的探索。

**著作权风险。**

开源代码有时候会渗透到其他代码中、或者其他代码渗透到开源代码中。根据不同的开源许可，则有可能不得不向整个社区公开原本不想公开的代码。例如，某些代码根据GPL等许可证合并到某些软件的源代码中，可能会“感染”该软件，从而导致该软件根据许可证的条款自动获得许可，也因此必须遵守该许可。例如，微软便遇到过该渗透问题，在微软将具有GPL许可的部分代码合并到其Hyper-V驱动程序中后，才发现该部分代码感染了微软的Hyper-V驱动程序，而微软不得不向Linux贡献了该Hyper-V驱动程序的代码以避免违反GPL。

**专利权风险。**

专利相对于著作权来说更加复杂，在获取专利权和维持专利权上要投入更多。专利在申请阶段就需要提交和申请很多文件，而一旦出现潜在的侵权问题，专利的诉讼成本也高于一般的著作权诉讼的成本。因此发起专利侵权诉讼本身就是对专利权人来说需要极为慎重考虑的事情。

另一方面，完全存在适用于许可软件但许可人和被许可人都不知道的专利。由于专利数量较多，开发者不可能了解世界上所有的软件。由于许可人只能许可属于他们的作品，因此特定软件许可的存在并不能保护被许可人免受第三方专利权人提出的侵权索赔。对专利风险的分析往往需要聘请律师来进行，成本也较高。
商业秘密问题。

对法院来说，软件的不当使用是一个很容易就能判断的问题，根据协议的条款，可以直接地看到哪些行为是不当使用。但何为商业秘密是很重要的，而在开源这一领域，商业秘密的判断则比较困难，因为开源软件本身就开放了很多信息，哪部分能够构成商业秘密是未来需要探讨的方向。原告仅仅声称某些信息是商业秘密是不足以构成商业秘密的，更何况还会有一些例如将所谓的商业秘密披露给了第三方且第三方无需保密的情况。
	
**认定受开源许可证影响的软件边界。**

高传染性。在过往的案件中，曾出现北京高级人民法院认为受GPL协议约束的软件中的插件并不受到GPL约束，而广州知产法院认同了GPL协议的“高传染性”，即在GPL3.0协议下开源软件的衍生作品或修改作品也需要遵循GPL许可协议开放其源代码。

独立程序。在2019年，最高院审理的一件计算机软件作品著作权纠纷案中认为前端和后端代码是独立的不同代码，前端代码用于页面设计等，而后端代码用于实现软件本身的底层逻辑，因此认为前端代码与后端代码在实际达到的效果和最终结果存在明显不同，且法院认为不能仅仅因为代码的交互配合就认定二者为同一代码。最高院认为GPL的高传染性包括基于开源软件的衍生程序或修订版本，但不包括存在交互或联系的其他独立程序。正如计算机系统中的多数软件或代码需要互相配合以达到目的，但这些软件或代码并非同一软件或代码。

开源的界限。开源软件经常涉及技术的跨国界传播，因此也需要面对各国国家的技术管制相关法律。Open source不等于open border。因为俄乌战事，GitHub官方发文称会遵守美国政府的相关规定，限制俄罗斯通过Github获得军事技术能力；开源社区例如Node.js、知名前端框架React等在其官网上加入声援乌克兰的标语；SUSE、红帽、Docker也纷纷宣布停止与俄罗斯的业务……由此可以看到，开源社区是在不同国家的法律下建立起来的，其必须遵守所在地的法律法规，因此，开源平台和开源企业实际上难以保持中立。开源软件的开发与维护往往涉及到不同的主体，也就涉及到不同的权利归属、许可、授权等法律问题。例如Linux基金会自身的管理办法不受美国出口管制，但Apache基金会的管理办法明确说明遵循美国出口管制。
	
### 8.2.3 开源软件供应链面临的挑战

软件供应链已经成为网络空间攻防对抗的焦点，直接影响关键基础设施和重要信息系统安全。软件的供应链安全问题由来已久，只是随着开源软件规模化应用，软件供应链愈发复杂多元，使开源软件供应链风险尤其突出。

对应传统供应链的概念，广义的开源软件供应链可以这样定义：开源软件供应链是一个实际业务系统，在开发和运行过程中，涉及的所有开源软件上游社区（Upstream）、源码包（Source Package）、二进制包（Binary）、包管理器（Package Manager）、存储仓库（Repository），以及开发者（Developer）和维护者（Maintainer）、社区（Community）、基金会（Foundation）等，按照依赖、组合、托管、指导等关系形成的供应链网络。

如今，软件开发更加关注敏捷和高效，基础功能通常会优先考虑复用相关的开源软件，开发者仅需进行必要的扩展和改进即可。这使得一个巨大的开源软件供应链体系逐渐浮出水面。Octoverse年度报告显示，截至2019年底，有超过360万个开源仓库对前50的开源项目有依赖，平均每个开源项目包含180个包依赖。从这些数据不难看出，在开源协作模式下，软件之间的供应链关系已经非常普遍和繁杂，构建和维护开源软件供应链已成为全球开源领域的共同挑战。

总体来说，当前中国开源软件供应链主要面临四方面的挑战。

**上游开源组件的漏洞传播与修复挑战。**

当一个常用开源组件因存在漏洞被修复时，我们希望把新版本快速同步到其他所有调用了该组件的开源项目中去，而不是同一个漏洞被一次次在不同软件中反复发现，反复修复，浪费人力物力，甚至被攻击者反复利用。上游组件的修复能否快速、大规模、全覆盖的推送到下游依赖环节，是开源软件供应链安全可靠性面临的重要挑战。

以2021年底爆发的Log4j2为例，Apache Log4j2零日漏洞（Log4Shell、CVE-2021-44228）是因“Lookup”机制存在解析问题，导致了JNDI注入漏洞。该漏洞的触发条件简单，但危害却极大。攻击者可向程序输入特定的攻击字符串，当程序进行日志记录时，该漏洞即可被触发，用来执行恶意代码。Log4j2是Java代码项目中广泛使用的开源日志组件，因此这个漏洞很快演变为一场Java生态中开源软件供应链的安全危机。据不完全统计，GitHub 超过8600多个开源软件直接依赖log4j2组件，但通过这些开源软件继续追溯，最终超过20万个开源软件受到了影响；同时，在官方第一次发布修复版本的一周时间后，仍然有超过80%的间接关联开源软件没有被修复。
 
可以看出，上游开源组件中一旦发现有严重漏洞，就会直接或间接地影响到下游开源软件，同时通过开源软件之间错综复杂的层级依赖关系的传播后，该漏洞隐匿在深层依赖的应用中不易被发现，为全球软件供应链带来无法估量且不可控的影响。
	
**关键开源组件的可持续维护挑战。**

开源软件的长期义务维护可能会导致一系列不公平的现象，例如商业公司通过开源软件赚取了丰厚利润，但并没有给维护者任何回馈，甚至会刻意回避谈及对开源软件的使用，由此引起开源维护者的反感甚至一些过激行为。2022年3月发生的faker.js与colors.js开源库遭作者Marak恶意破坏的事件就是典型的例子。faker.js与colors.js使用范围较广，faker.js在npm上的每周下载量接近250万、colors.js达到约2240万，属于较为关键的开源软件供应链上游节点。faker.js使用的是十分宽松的MIT开源许可协议，因此许多商业公司并没有为使用此项目支付任何费用。作为fake数据领域最优秀的开源项目之一，faker.js和colors.js庞大的工作量却主要由其作者Marak一人完成，并且没有从商业公司得到相应的支持和回报。长期累积的恶性循环终于爆发，作者通过向两个包提交恶意代码进行供应链投毒，并发布到GitHub和npm包管理器中，之后又将项目仓库所有代码清空，完全停止维护，从而使依赖于这两个库的数千个项目无法运行。

其实早在2014年HeartBleed漏洞爆发时，人们已经发现出现问题的OpenSSL库只有两位兼职人员在义务维护。同样，前面提到的Log4j也仅有几位兼职社区开源爱好者在维护。可想而知，这些软件包在出现漏洞后，修复的及时程度和全面程度必然会受到影响。

**大企业垄断开源生态阻碍创新。**

开源一直秉承鼓励创新的发展理念，已成为推动全球数字科技创新的重要因素。数据表明，开源技术支撑了90%以上的互联网产品，推动了一大批小而精的创新型企业发展壮大。开源倡导开放、共享的模式，兴起之时就遭到众多科技巨头的坚决抵制，但随着开源势不可挡的发展，全球科技巨头转而持续加码开源领域，纷纷通过收购开源平台强化其垄断地位，试图通过掌控开源平台不断强化对科技生态的领导力，并使得社区从早期的高度分散的技术架构转变为由几个强大的网络巨头所控制的架构。这种“大公司拥抱开源”的现象，一方面因大公司拥有在更高级别上开发和维护开源项目所需的资金，推动产生了更多的开源重点项目，并有助于提高质量和安全性；另一方面，受商业利益等因素驱使，通过对开源社区项目的开发和商业化推广，对开发人员施加种种限制，易造成技术垄断，并最终阻碍技术创新。

在过去十年中，从Linux和MySQL到Kubernetes、Spark、Presto和 MongoDB，开源一直是云创新的支柱，但部分大型云服务商正在改变开源的形态，可能会破坏开源创新的激励因素。大型云服务商很容易获取到优质的开源项目，并将其作为托管服务提供个客户。这些大企业并没有动力去回馈开源社区，很自然地从这些别人的工作中获得不公平的利润，从而破坏了开源创新所需要的发展动力。如果这种现象持续存在，将会极大地对开源从业者创办企业和获得投资方面产生抑制作用。

另外一些国际巨头不断通过垄断开源生态，在产业链中具有掌握极大话语权，并以此获益。例如谷歌旗下的操作系统Android、浏览器Chrome、深度学习框架TensorFlow、容器编排引擎Kubernetes等，分别在各自的领域占据优势地位，这些开源产品自身具有一定通用性和适用性，便于后续开发者 “不重复制造轮子”而在其产品的基础上进行进一步开发，但又通过人为制造诸如广告服务、有意破坏其他竞品连接谷歌服务的用户体验等方式排除竞争者获得垄断地位，最后从高达30%谷歌应用商店抽成，内置Android系统的Google ADs，以及GMS服务授权费用等途径获得高额的垄断利润。尽管这些产品本身都是开源的，但中小企业和个体开发者在面对谷歌限定的服务接口、苛刻的商业条款等问题时，很少有能力再进行创新并反馈开源社区，开放共享的初心被完全破坏殆尽。
	
**国际局势动荡的挑战。**

开源软件供应链除了面临上述两方面的挑战之外，在最近几年也出现了意识形态、地缘政治、战争冲突等导致的开源社区分裂。一些关键的开源托管平台和开源基础软件对特定国家、特定实体雇员采取了账号禁止访问、代码删除等“断供”行为，这也是未来开源软件发展面临的又一巨大挑战。

开源无国界，但开源组织（如基金会）、开源代码托管平台（属于商业公司所有）都会受到属地出口管制政策的制约。

为了应对供应链存在的安全问题，首先应整体考虑供应链上下游关系，明确开源软件供应链的各个环节组成。其次，应对软件供应链产品进行全生命周期安全保障，从上游开始一直到软件部署及运行，对各个环节进行安全评估。此外，应从开发者、开源社区、地区分布等多个维度进一步评估关键开源软件的维护性和演化能力，确保其在供应链中的可靠性。最终极的解决方案，则是在上游开源软件和开源社区的基础上，由具有社会公信力的机构，牵头打造开源软件供应链基础设施，形成公共服务能力，对千行百业提供高质量、可持续的开源软件供应。

构建健全的开源供应链生态，一是注重培养开源软件供应链安全人才。建设开源供应链安全运维团队，建立关键供应链所涉及的各行业、企业内部当然应成立一支高素质的维护团队。大力培养开源供应链安全管理、技术与战略人才，从战略、战术上给予重点培育培养。二是构建开源供应链安全评估体系。扶持一批从事开源软件安全评估的创新企业，打造开源供应链的安全评估体系。从开发者个人、企业发展、开源组织、国家政策等五个维度构建开源供应链安全评估框架，制定开源供应链安全行为准则，实时监测国内开源供应链的重点事件。从战略政策层面，持续关注跟进开源软件、开源硬件供应链的国际形势。实时跟踪了解国际开源供应链的动态，特别是各国在开源供应链方面的政策举措及落地方案。三是建立开源供应链安全实验室。以信息产业安全发展为目标，以繁荣开源生态为导向，确保信息产业供应链安全。通过开源供应链安全实验室打通个人开发者、企业、政府管理部门三者之间的旋转门机制，鼓励企业的一线开源开发者到政府管理部门工作，同时允许政府管理人员到开源企业从事管理与战略工作。

以中国科学院软件研究所为例，从2019年起在中科院先导专项的支持下开始建设开源软件供应链管理平台，目前已完成设施原型开发以及可视化展示。平台累计完成超过662万款开源软件的采集及对应知识图谱构建，是当前已知最大规模源代码知识图谱：代码量超过100亿行，软件图谱实体数量超过1300万个，节点属性超过781种，关系数量超过1.8亿条，涵盖操作系统、数据库、人工智能等主要供应链。基于知识图谱技术，设施对数百万开源软件属性特征和结构特征进行了分析，结合重要性算法、流行度算法、安全性算法、风险预警算法及软件健康度评判机制，实现了对于开源软件供应链关键节点的识别与验证。此外，通过实时监控开源软件漏洞事件舆情做到早发现、早评估、早修复，保证关键节点的安全可靠。

在开源人才培养方面，中科院软件所于2020年发起了“开源软件供应链点亮计划”，包含“开源之夏”、开源维护人员招募计划等系列活动，旨在搭建高校开发者与开源社区的沟通桥梁，吸引高校开发者参与开源社区贡献。

### 8.2.4 中国开源产业的人员危机
**人才供需对接的效率低。**

据GitHub《2021年度Octoverse报告》统计，中国开发者人数占比排名第二，有 755万+。按照中国数字经济转型发展的要求，2022年中国人才需要有1200万的缺口。但企业找到恰当的、需要的人才成本依然很高，普通大学毕业生去企业之后要1-2年才能适应开源等工作的岗位要求，总体来看，人才培养周期长，加剧了企业的开源人才挑战。
	
高技能人才匮乏，顶尖开源人才更难寻。

在吸引顶尖人才方面，我国依然缺乏竞争力，在高层技术专家和人才严重匮乏方面尤其明显。目前我国技能劳动者已经超过2亿，高技能人才仅占技能人才总量的28%，这个数据与发达国家普遍40%以上的数据相比，仍然存在很大差距。大部分开源企业创业者表示，顶尖开源难寻是企业开源人才招聘中的一大难点。
	
企业对开源人才的培养成本投入少，开源人才留存困难。

《2021年开源工作报告》指出，组织对顶级开源人才的需求已大于以往任何时候。但行业人才仍供不应求，一些企业也很难留住现有的开源人才。由于工作时间长、压力大、企业凝聚力弱等问题，给开源人才的留存造成了一定困难。并且，多数企业存在人工成本居高不下，对开源人才的支持与培养投入少，导致在开源人才管理方面也面临一些挑战。
	
关于缓解开源人才危机的建议。

加强高校开源培养教育。在高校推进开源教育，建立产学研一体化开源创新人才培养体系，是我国开源创新人才的培养的重要路径。首先，可基于优秀国产开源成果进行课程体系设计、师资队伍建设和培养计划制定，培养开源创新人才，支撑国产开源软件形成可持续发展生态。其次，加强开源文化和开源技能教育，建立鼓励软件成果开源的评价机制和价值导向，推动高校产出更多原创性开源成果。最终，以开源教育为抓手，打造新型产教融合平台，建立从高校开源学习、产业开源实践到开源创新创业的闭环，服务中国软件产业发展。

加强开源社区建设及社区间合作。据调查，50%以上企业管理者认为 “从开源项目团队或开源活动中直接引入”是开源人才引进的有效渠道。而不同开源社区间多合作，更能促进整体的开源生态繁荣。

建立企业开源人才成长体系的培养机制。多数企业有针对开源人才成体系的培养机制，增加对现有员工的培训，不仅可以缩小技能差距，为开源人才提供培训机会也正在成为吸引他们留下来的重要方式。

优化开源人才薪酬福利待遇。薪资福利一向是吸引人才的有效手段。据调查，39%的公司愿意给予开源人才的加薪幅度高于其他业务人员。近半数受访开源企业，为开源人才提供的薪酬总额（税前），包括工资、奖金和津贴，考虑的上调比例是：10%~20%。优化开源人才薪酬福利待遇有助于增加开源相关岗位的吸引力，一定程度上可缓解开源人才危机。

如今，开源与各技术领域携手同行的势头有增无已，开源有助于各技术领域扩大人才规模及上下游生态影响力，通过运营开源社区快速获得反馈并加快产品开发、提升产品质量，同时反哺社区开发者及独立软件开发商（ISV）等生态伙伴，能够达到多方共赢目的。
